///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Camera export method.
 *	This method is called once for each exported camera.
 *	\param		camera		[in] a structure filled with current camera information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ASCIIFormat::ExportCamera(const CameraDescriptor& camera)
{
	// Export common information
	mCameras.StoreASCII("\n///////////////////////////////////////////////////////////////////////////////////////////////////////////////////\n").StoreASCII("Camera:       ");
	ExportBasicInfo(&camera, &mCameras);

	// Export camera parameters
	if(camera.mOrthoCam)
	{
		mCameras.StoreASCII("Type: orthographic\nWidth: ").StoreASCII(camera.mFOV).StoreASCII("\n");
	}
	else
	{
		mCameras.StoreASCII("Type: perspective\nField Of View: ").StoreASCII(camera.mFOV).StoreASCII("\n");
	}

	// Horizon line display
	mCameras.StoreASCII("Horizon line display: ")	.StoreASCII(camera.mHLineDisplay).StoreASCII("\n");	// Horizon line display

	// Export environment ranges if needed
	// Environment ranges
	mCameras
		.StoreASCII("\nENVIRONMENT RANGES:\n")
		.StoreASCII("\nNear range: ")				.StoreASCII(camera.mEnvNearRange)					// Near range
		.StoreASCII("\nFar range: ")				.StoreASCII(camera.mEnvFarRange)					// Far range
	// Environment display
		.StoreASCII("\nEnv display: ")				.StoreASCII(camera.mEnvDisplay)						// Environment display
		.StoreASCII("\n");

	// Export clipping planes if needed
	mCameras
		.StoreASCII("\nCLIPPING PLANES:\n")
		.StoreASCII("\nManual clip: ")				.StoreASCII(camera.mManualClip)						// Manual clip
		.StoreASCII("\nNear clip: ")				.StoreASCII(camera.mNearClip)						// Near clip
		.StoreASCII("\nFar clip: ")					.StoreASCII(camera.mFarClip)						// Far clip
		.StoreASCII("\n");

	return true;
}
